# 管理后台{#admin}

## 概述

系统运行依赖于后台的管理设置，同时也提供一些信息查询如日志、系统信息等。  
后台管理主要包含了系统信息、系统设置、Ai设置、全局字典、邮件设置、用户管理、项目模板、项目管理等功能模块。 
点击左侧菜单上方的"管理"，金科进入管理页面。 
或者以下Url访问：
  `/admin` 

注：  后台管理需要管理员权限，普通用户无法登录。

![管理后台](/admin/sidebar.png)


## 1. 系统信息{#system-info}

- 系统负载，查看系统当前的CPU、内存、磁盘等资源使用情况
- 系统信息，查看系统版本、工作目录、数据库信息、上传相关
- 查看系统许可证信息
- 查看系统运行日志

 ![系统信息](/admin/info.png)

## 2. 系统设置{#global-setting}

### 2.1资料设置
 用于设置公司信息和联系人信息 

### 2.2 基本设置
- 应用状态，如果禁用则不允许登录系统
- 是否允许用户注册 
- 登录认证最大尝试次 
- 登录时是否需要验证码 
- 注册时是否需要验证码 
- 项目名称最大长度 
- 项目键值最大长度 

### 2.3 附件设置
- 附件大小限制，默认 `128M`
- 允许上传的附件后缀，默认 `doc, docx, xls, xlsx, ppt, pptx, htm, html, txt, zip, rar, gz, bz2, pdf,jpg, jpeg, png, gif,swf, flv, mp3, wav, wma, wmv, mid, avi, mpg, asf, rm, rmvb, mp4, aac, json`
- 允许上传的图片文件后缀，默认 `jpg, jpeg, png, gif`
- 允许上传的媒体文件后缀，默认 `swf, flv, mp3, wav, wma, wmv, mid, avi, mpg, asf, rm, rmvb, mp4, aac`
- 允许上传的媒体文件后缀，默认 `swf, flv, mp3, wav, wma, wmv, mid, avi, mpg, asf, rm, rmvb, mp4, aac`
- 附件存储路径配置

### 2.4 时间设置
  - 默认时区，默认 `Asia/Shanghai`
  - 日期格式(年月日)，默认 `Y-m-d`
  - 完整日期/时间格式，默认 `Y-m-d H:i:s`
  - 短时间格式，默认 `H:i:s`

### 2.5 文档设置
  - 文档上传路径
  - 文档上传大小限制
  - 文档上传后缀限制


### 2.6 API设置
- API访问控制
- API密钥管理

![API设置](/admin/api.png)


### 2.7 缓存设置
- 缓存清理操作
- redis缓存地址和端口

![缓存设置](/admin/cache.png)

### 2.9 管理权限
- 全局的角色权限分配
![全局的角色权限分配](/admin/role.png)



## Ai设置
- 全局的Ai模型配置，要启用Ai功能，需要在这里添加大模型。支持设置Ai调用的参数。 
![全局的Ai模型配置](/admin/ai_setting.png)

![全局的Ai模型配置](/admin/ai_model.png)



## 3. 全局字典{#global-dictionary}
项目的事项引用全局字典，你可以在管理。 
- 事项类型
  默认提供了任务、缺陷、新功能（需求）、优化改进、Bug等事项类型。 
  你也可以在管理中添加自定义的事项类型。可以设置图标、颜色、排序等。 
  事项类型添加后，在创建事项时可以选择。
  ![事项类型](/admin/type.png)


- 事项优先级
  默认提供了严重、重要、高、中、低、轻微低五个优先级。 
  你也可以在管理中添加自定义的优先级。可以设置颜色、排序等。 
  事项优先级添加后，在创建和编辑事项时可以选择。 
  ![事项优先级](/admin/priority.png)

- 事项状态
  默认提供了待开始、就绪中、进行中、暂停、接近完成、已完成、已取消、已关闭六个状态。 
  你也可以在管理中添加自定义的状态。可以设置颜色、背景颜色、排序等。 
  事项状态添加后，在创建事项时可以选择。 
  ![事项状态](/admin/status.png)

- 事项复杂度
  默认提供了非常难、难、普通、容易等复杂度。 
  你也可以在管理中添加自定义的复杂度。可以设置颜色、排序等。 
  事项复杂度添加后，在创建事项时可以选择。 
  ![事项复杂度](/admin/complex.png)

- 事项解决结果
  默认提供了未解决、已解决、无效、重复等解决结果。 
  你也可以在管理中添加自定义的解决结果。可以设置颜色、排序等。 
  事项解决结果添加后，在创建事项时可以选择。 
  ![事项解决结果](/admin/resolve.png)


- 事项字段管理
  你可以在管理中添加自定义的事项字段。可以设置字段名称、类型、是否必填、是否唯一、是否索引、是否加密、是否隐藏等。  
  字段类型支持：文本、数字、日期、时间、日期时间、下拉列表、单选框、多选框、文件上传、图片上传、文本域等。 
  事项字段添加后，在创建事项时可以选择。
  ![事项字段管理](/admin/field.png)



## 4. 邮件发送配置{#email-sending-configuration}
- SMTP服务器设置
  你需要在管理中配置SMTP服务器信息，才能发送邮件。 
  配置完成后，即可在创建事项时发送邮件。
  ![SMTP服务器设置](/admin/smtp.png)

- 邮件发送测试
  你可以在管理中测试邮件发送功能。
  测试完成后，即可确认邮件发送功能正常。
  ![邮件发送测试](/admin/send_mail_test.png)


- 邮件发送队列
  你可以在管理中查看邮件发送队列。
  队列中包含了待发送的邮件。
  你可以在队列中查看邮件的发送状态。
  你也可以在队列中删除邮件。

- 邮件通知规则配置
  你可以在管理中配置邮件通知规则。
  配置完成后，即可在创建事项时发送邮件。
 


## 5. 用户管理{#user-management}
 用户管理页面可以查看所有的用户，支持创建、编辑、禁用用户。 
- 用户列表查看与搜索
- 新增/编辑/禁用用户
- 用户角色分配
- 用户权限管理

 ![用户管理](/admin/user.png)



## 6. 项目管理{#project-management}
 注：该功能测试中暂未完成，后续会完善。

- 项目归档与恢复以及删除

## 7. 日志查询{#log-query}
  
- 操作日志查询与筛选 
  当配置文件的`log_operation_record`开启为`true`时，才会记录操作日志。
![日志列表](/admin/request_log.png) 

- 日志详情 
  点击日志列表中的日志，即可查看日志详情。

![日志详情](/admin/request_log_detail.png)


## 8. 系统管理{#system-management}
 注：该功能测试中暂未完成，后续会完善。
- 数据备份与恢复
- 定时任务配置

## 9. 更新检查{#update-check}
 注：该功能测试中暂未完成，后续会完善。
- 系统版本检测
- 补丁更新
- 更新日志查看
- 自动更新配置