# Dectask 最佳实践指南


## 1. 系统使用流程和角色职责分工

### 1.1管理员操作
  - 初始化系统
  - 配置系统参数
  - 配置邮件发送
  - 用户管理（添加改用户或邀请用户加入）
  - 配置全局字典（事项类型，状态、优先级、事项类型、字段等）
  - 配置事项类型表单字段和布局
  - 配置邮件发送
  - 创建项目
    - 配置项目信息和设置
    - 配置项目角色权限
    - 将用户添加到项目（项目管理员，成员等）
  
### 1.2 项目管理员操作
  - 登录系统（管理员邮件邀请或后台创建）
  - 进行项目设置，包括项目名称、描述、成员管理、角色权限等
  - 管理项目事项
    - 创建事项
    - 分配事项
    - 跟踪事项进度
    - 关闭事项

  
### 1.3 项目成员操作
  - 登录系统（项目管理员或邮件邀请，管理员后台创建）
  - 管理项目事项
    - 创建事项
    - 分配事项
    - 跟踪事项进度
    - 关闭事项

### 1.4 利益相关者 
- **职责**  
  - 查看进度、提供反馈
- **权限**  
  - 只读权限（查看任务状态、报表、甘特图）  
  - 部分工具允许"评论权限" 

### 1.5 外部协作者 
- **职责**  
  - 临时参与特定任务（如顾问、外包团队）
- **权限**  
  - 仅访问指定事项或文件  
  - 限制查看其他项目或成员信息
 

## 2.Url规则
系统预定义了访问项目的Url规则，如下：
- 组织列表：`/p/org`
- 项目列表：`/p/projects`
- 项目首页：`/p/{org_path}/{project_key}`
- 项目事项列表：`/p/{org_path}/{project_key}/issues`
- 项目事项详情：`/p/{org_path}/{project_key}/issues/{issue_id}`
- 项目概要：`/p/{org_path}/{project_key}/summary`
- 项目动态：`/p/{org_path}/{project_key}/activity`
- 项目日历视图`/p/{org_path}/{project_key}/calendar`
- 项目计划甘特图：`/p/{org_path}/{project_key}/plan`
- 项目敏捷管理：`/p/{org_path}/{project_key}/sprints`
- 项目看板管理：`/p/{org_path}/{project_key}/boards`
- 项目文件管理：`/p/{org_path}/{project_key}/document/root`
- 项目规则：`/p/{org_path}/{project_key}/rules`
- 项目报告：`/p/{org_path}/{project_key}/report`

`{org_path}`：组织标识符，用于唯一标识一个组织。
`{project_key}`：项目标识符，用于唯一标识一个项目。
`{issue_id}`：事项ID，用于唯一标识一个事项。




## 3. 命名或显示设置
### 2.1 命名约定
- **项目标识**：使用`项目英文缩写`（如`proj`）
- **事项标题**：采用不同类型不同的格式
  - 任务：`任务内容简述（如`新增用户注册功能`）`
  - Bug：`问题描述`（如`无法登录提示密码错误`）
  - 改进：`改进建议描述`（如`优化用户界面`）

### 2.2 用户信息
- 显示名称：与实际姓名一致
- 头像：上传真实头像，避免使用默认头像
- 邮箱：使用公司邮箱，确保与实际姓名一致




## 4. 状态和解决结果
- **状态**：事项的当前状态，如待处理、进行中、已完成等。
- **解决结果**：用于验证问题是否已解决，如已解决、未解决等。
可针对不同的角色做出设置和定义，如开发者可以修改状态，测试人员和项目经理进行解决结果的修改。




## 5.状态流设置

根据你自己的情况，定义状态流转，同时要启用严格状态流模式。这些操作在项目设置中进行，如下图：



![启用严格状态流](/issue/state_flow_enable.png)  

![状态流转图](/issue/state_flow.png)





