# 普通安装 {#install}

Dectask支持不同的操作系统，包括Windows、macOS和Linux。安装过程相似。通过以下步骤，你可以快速安装 Dectask，最快 1 分钟完成安装：

## 系统要求

- **操作系统**：Windows 7或更高版本，macOS 10.15 或更高版本，或 Ubuntu 18.04 或 Centos 7.0 或更高版本
- **内存**：建议 4GB 或更多
- **硬盘空间**：建议 10GB 或更多
- **浏览器**：最新版本的 Chrome、Firefox 或 Safari


## 安装步骤

Dectask依赖Mysql数据库，所以需要先安装Mysql数据库。Redis数据库是可选的，建议安装和启用，以提高性能。


### 1.下载和安装Mysql8数据库

Dectask 依赖于 Mysql8 数据库，你需要先安装 Mysql8 数据库。根据你的操作系统，选择合适的版本进行下载：

- **Windows**：[下载链接](https://dev.mysql.com/downloads/windows/installer/)
- **Linux**：[下载链接](https://dev.mysql.com/downloads/mysql/)

安装Mysql后，使用Mysql客户端如Navicat或Mysql Workbench,创建数据库`dectask`,字符集为`utf8mb4`,并创建用户dectask和密码。
同时解除Mysql严格模式。

```sql
-- 解除严格模式
SET GLOBAL sql_mode='NO_ENGINE_SUBSTITUTION';

-- 创建数据库dectask
CREATE DATABASE IF NOT EXISTS dectask CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- 创建用户dectask,密码
CREATE USER 'dectask_user'@'%' IDENTIFIED BY 'dectask_password';

-- 授权用户dectask_user
GRANT ALL PRIVILEGES ON dectask.* TO 'dectask_user'@'%';

-- 刷新权限
FLUSH PRIVILEGES;
```


### 2.下载 Dectask

根据你的操作系统，选择合适的版本进行下载：

- **Windows**：[dectask-windows-amd64-4.0.16.zip](http://download.dectask.com/dectask-windows-amd64-4.0.16.zip)
- **Linux**：[dectask-linux-amd64-4.0.16.zip](http://download.dectask.com/dectask-linux-amd64-4.0.16.zip)

将下载好的文件解压到一个目录中，例如：`/data/dectask`，并赋予该目录读写权限


### 3.安装和启动 Dectask

将下载好的Dectask解压到一个目录中，例如：`/opt/dectask`
在解压后的目录中，编辑 `config.yaml` 文件，将数据库连接信息填写正确。

```yaml
#其他内容暂不配置
mysql:
  path: 'localhost:3306'
  config: 'charset=utf8mb4&parseTime=True&loc=Local'
  dbname: 'dectask'
  username: 'dectask'
  password: '修改为自己的密码'
```

安装过程需要打开命令行窗口，切换到Dectask目录，执行以下命令安装Dectask。
```shell
 ./dectask install zh_cn
 # 安装成功后会输出管理员账号和密码，请牢记
 # 装成功后会输出管理员账号和密码，请牢记

```
安装成功后，执行以下命令启动Dectask。
```shell
  ./dectask 
```
守护进程方式运行
```shell
  ./dectask -d
```
停止和重启命令
```shell
  ./dectask stop
  ./dectask restart
```


之后就可以在浏览器 http://localhost:8888/login 上访问 Dectask 了.如需要修改端口,可以在config.yaml中修改.

登录界面如下  
![登录界面](/passport/login.png)


### 4.安装和启用Redis（可选）

Dectask 建议安装和启用 Redis 数据库，以提高性能。根据你的操作系统，选择合适的版本进行下载：

- **Redis下载**：[下载链接](https://redis.io/download)

安装 Redis 后，编辑 `config.yaml` 文件，将 Redis 连接信息填写正确。

```yaml
#redis配置,根据实际情况修改
redis:
  db: 0
  addr: '127.0.0.1:6379'
  password: ''
```

重启命令
```shell
  ./dectask restart
```


