# Ai功能 {#ai}

Dectask将Ai技术应用与实际功能中，以实现智能的项目管理。 
支持的大模型有：
- OpenAI 
- Deepseek
- Anthropic
- 阿里千问
- 以及图像生成模型：字节即梦和阿里万相



应用场景：
- 智能聊天：根据用户的输入，提供智能的聊天回复。基于Function Call能够返回数据图表。
- 报告图表的数据源Sql辅助生成：根据用户的输入，生成对应的Sql语句。 
- 智能输入：能够自动根据用户的输入，生成对应的事项。 
- 集成文档，智能助手：能够与文档进行集成，实现智能的助手功能。 
- 集成Mcp Server：能够与Mcp Server进行集成，实现更多的功能。 



点击左侧菜单上方"Ai助手"，可访问Ai页面。 

### Ai助手页面

![Ai助手页面](/ai/index.png)

在Ai助手页面，用户可以输入问题或指令，然后点击提交按钮，即可获取Ai的回复。支持都会话管理，用户可以在会话中进行多轮对话。


系统提供几个选项：
- 项目范围： 可限制Ai助手的作用范围，仅生成与当前项目相关生成内容。
- 模型：选择使用的模型。可以使用自己的模型，提供两种协议支持: Ollama和Openai兼容协议
- 返回格式：选择返回的格式，如：文本、Markdown、图表、代码等。
- 提交数据选项：如果开启此选项，用户输入的内容和项目相关数据将被提交到Ai模型中，请谨慎操作。



### Ai模型管理
要使用Ai功能，需要先配置Ai模型。可在"管理"/"Ai设置"/"模型管理"进行模型的添加、修改和移除。

![Ai模型管理](/ai/ai_model.png)

![Ai模型管理](/ai/ai_model_add.png)


根据提示填写模型的名称、类型、Api Key、Api Base等信息。然后在"管理"/"Ai设置"/"默认设置"，设置模型的模型，这样才Ai助手页面中，默认选择该模型。

![Ai模型管理](/ai/ai_model_default.png)

### Ai默认设置

在"管理"/"Ai设置"/"默认设置"，可以设置默认的模型、默认的温度、默认的最大Tokens等。这些参数将会影响Ai的内容生成。
- 模型：选择默认的模型。
- 温度：控制生成内容的随机性，值越高，生成的内容越随机；值越低，生成的内容越确定。
- 最大Tokens：控制生成内容的长度，值越大，生成的内容越长；值越小，生成的内容越短。


### Mcp 服务器
Mcp服务器是Dectask的一个功能模块，用于与Ai模型进行通信。它支持 sse 、http和stdio三种传输类型。

- sse：基于Server-Sent Events协议，支持实时通信。
- http：基于HTTP协议，支持同步通信。
- stdio：基于标准输入输出流，支持同步通信。

传输类型为`stdio`时，启动命令
```
 ./dectask.exe mcp start
```
Mcp inspector 客户端连接示例  

![McpSTDIO设置](/ai/mcp_stdio.jpg)


sse和http传输类型和端口设置，需要在config.yaml中设置，如下：

``` yaml
# ai mcp 配置
mcp:
  # 传输类型, 可选值: sse, http 
  transport_type: 'sse'
  # 端口
  port: 8088
```
``` 
# 当传输类型为sse时，端口为8088时的连接地址的示例
http://localhost:8088/sse

# 当传输类型为http时，端口为8088时的连接地址的示例
http://localhost:8088/mcp
 
```



支持在后台管理页面中，启用或停用 mcp 服务器。

![Mcp服务器设置](/ai/mcp_setting.jpg)


支持进行 `API Token Authentication`级别的认证。当后台配置认证token时，调用mcp时需在header中提交`Authorization`。  

![Mcp 认证](/ai/auth.jpg)

![Mcp 认证](/ai/auth_header.jpg)
 
 


 
