# 配置文件

DecTask 配置文件为 `dectask.yaml`，默认位置为项目根目录, 可以通过 `-c` 选项指定配置文件路径,格式为 `yaml`, 
yaml 格式是一种流行的数据序列化格式, 说明请参考 [YAML 语法](https://www.runoob.com/w3cnote/yaml-intro.html)。


```yaml

# DecTask Server Configuration

system:
# 域名
  domain: 'localhost' 
 # 端口
  port: 8888 
  # 加密密钥 
  encrypt_key: 'MaobXvXVMvzb1hvT3434' 
  # 环境, 可选值: dev, prod
  env: 'prod' 
  # 数据库类型, 可选值: mysql, postgres(后续支持)
  db_type: 'mysql' 
  use_multipoint: false
  # 是否开启缓存
  enable_cache: false 
  # 是否允许所有域名访问, 建议在生产环境下关闭
  allow_all_origin: true 
  # 允许访问的域名, 建议在生产环境下关闭
  allow_origins: 
      - http://localhost
      - http://127.0.0.1
  log_operation_record: false

ssl:
  # 是否开启 SSL
  enable_ssl: false
  # SSL 证书文件路径
  ssl_pem: "resource/ssl/cert.pem"
  # SSL 密钥文件路径
  ssl_key: "resource/ssl/key.pem"
  # 是否为开发环境, 开发环境下会打印更多日志
  is_development: true

# mysql 配置
mysql:
  # 数据库连接地址
  path: 'localhost:3306'
  # 数据库连接配置
  config: 'charset=utf8mb4&parseTime=True&loc=Local'
  # 数据库名称
  dbname: 'dectask'
  # 数据库用户名
  username: 'dev_user'
  # 数据库密码
  password: '123456'
  # 数据库最大空闲连接数
  max_idle_conns: 10
  # 数据库最大打开连接数
  max_open_conns: 100
  # 是否开启数据库日志
  log_mode: true
  # 数据库日志级别
  log_zap: ""
  # 数据库慢查询阈值
  slow_threshold: 10000

# redis 配置
redis:
  # 数据库编号
  db: 0
  # 数据库连接地址
  addr: '127.0.0.1:6379'
  # 数据库密码
  password: ''
  # 数据库垃圾回收频率
  gc_rate: 10

# worker pool 配置 ，用于异步处理任务，当服务器配置较低时可减少任务池大小
worker:
  # 活动动态任务池大小
  activity: 10
  # 通知任务池大小
  notify: 20
  # webhook 任务池大小
  webhook: 20
  # 规则任务池大小
  rule: 50

jwt:
  # 登录jwt签名密钥，修改后需要重启服务，后续修改将会导致登录失败
  signing_key: 'qmPlus'
  expires_time: 604800
  buffer_time: 86400
# 日志配置
zap:
  # 日志级别
  level: 'info'
  format: 'console'
  prefix: '[DecTask]'
  director: 'log'
  link_name: 'latest_log'
  show_line: true
  encode_level: 'LowercaseColorLevelEncoder'
  stacktrace_key: 'stacktrace'
  log_in_console: true

casbin:
  model_path: 'resource/rbac_model.conf'
  policy_path: 'resource/rbac_policy.csv'
# 验证码设置
captcha:
  key_long: 6
  img_width: 200
  img_height: 60
# 上传文件存储默认配置
local:
  path: 'attachment/file'

import_no:
  en: 'NO'
  zh_cn: '编号'  

# ai mcp 配置
mcp:
  # 传输类型, 可选值: sse, http , stdio
  transport_type: 'sse'
  # 端口, 当 transport_type 为 sse 或 http 时
  port: 8088


```
