# Docker方式安装 {#install_docker}



## 系统要求

- **Docker**：Docker 19.03 或更高版本
- **Docker-Compose**：Docker-Compose 1.29 或更高版本

Docker 和 Docker-Compose 安装请参考以下文档，如果你已经安装则忽略本步骤：
- [Linux Centos 7 Docker和Docker-Compose 国内安装教程](https://help.aliyun.com/zh/ecs/use-cases/install-and-use-docker#4787944e3bwid)
- [Linux Ubuntu 20.04 Docker和Docker-Compose 国内安装教程](https://help.aliyun.com/zh/ecs/use-cases/install-and-use-docker#8dca4cfa3dn0e)
- [Linux Debia Docker和Docker-Compose 国内安装教程](https://help.aliyun.com/zh/ecs/use-cases/install-and-use-docker#59d024a3e32um)

安装docker后，建议设置加速镜像为国内镜像源。

配置镜像加速器方法
```
sudo mkdir -p /etc/docker
sudo tee /etc/docker/daemon.json <<-'EOF'
{
  "registry-mirrors": ["https://docker.m.daocloud.io"]
}
EOF
sudo systemctl daemon-reload
sudo systemctl restart docker


```
如果 `https://docker.m.daocloud.io` 用不了，请更换为其他地址  
如果是阿里云服务器可使用加速地址 `https://c9jzs6ju.mirror.aliyuncs.com`

如果是非root用户，请自行修改Dockerfile文件进行配置



## 构建镜像
```shell
docker build -t dectask-server .
```
## 启动容器
修改 config.yaml 文件进行端口和数据库等配置项,运行
```shell
docker run -d \
  -p 8888:7777 \
  --name dectask \
  --network=host  \
  dectask-server
  
```
docker启动后会自动启动安装和初始化服务，并生成管理员账号和密码
```shell
 # 查看管理员账号和密码
docker exec dectask cat /app/log/account.log
```
常用的docker命令
```shell
 # 常用的命令
docker ps -a
docker stop dectask
docker start dectask
docker rm -f dectask
docker exec -it dectask /bin/sh
docker logs -f dectask
docker images  
 
```
## 支持环境变量
支持环境变量方式启动，环境变量的值优先级高于config.yaml的配置项目

可用环境变量有
```shell
# 绑定域名 可以设置为 0.0.0.0
DECTASK_SYSTEM_DOMAIN=localhost  
# 绑定端口
DECTASK_SYSTEM_PORT=8888
# 生产环境 prod 开发环境 dev
DECTASK_SYSTEM_ENV=prod
# 加密密钥,自行修改
DECTASK_SYSTEM_ENCRYPT_KEY=DECTASK_SYSTEM_ENCRYPT_KEY
# 数据库类型,目前仅支持mysql
DECTASK_SYSTEM_DB_TYPE=mysql
# 数据库连接地址, 更改为实际的
DECTASK_DB_PATH=localhost:3306
# 数据库名称, 更改为实际的
DECTASK_DB_DBNAME=dectask
# 数据库用户, 更改为实际的
DECTASK_DB_USER=dev_user
# 数据库密码, 更改为实际的密码
DECTASK_DB_PASSWORD=123456
# 缓存开关, 默认关闭
DECTASK_SYSTEM_ENABLE_CACHE=false
# 缓存类型, 目前仅支持redis, 设置redis的地址和端口
DECTASK_REDIS_ADDR=127.0.0.1:6379
# 缓存密码, 默认为空
DECTASK_REDIS_PASSWORD=
# jwt密钥, 可修改
DECTASK_JWT_SIGNING_KEY=qmPlusfdfsdfdsffcxxsdfssfdsg
# 日志级别
DECTASK_ZAP_LEVEL=info
# 附件保存路径
DECTASK_ATTACHMENT_PATH=attachment/file

# 开启https PEM 证书路径
DECTASK_SSL_PEM=ssl/pem
# 开启https KEY 证书路径
DECTASK_SSL_KEY=ssl/key

# mcp 传输类型, 可选值: sse, http , stdio
DECTASK_MCP_TRANSPORT_TYPE=sse
# mcp 端口, 当 DECTASK_MCP_TRANSPORT_TYPE 为 sse 或 http 时
DECTASK_MCP_PORT=8088


````
docker 设置环境变量启动示例
``` shell
  # 可传入环境变量
 docker run -d \
  -p 8888:7777 \
  --name dectask \
  -e DECTASK_DB_PATH=127.0.0.1:3306 \
  -e DECTASK_DB_DBNAME=dectask_docker \
  -e DECTASK_DB_USER=dectask_docker \
  -e DECTASK_DB_PASSWORD=FiSx2GfbS8882EMb \
   --network=host  \
  dectask-server  
  

 # 查看管理员账号和密码
docker exec dectask cat /app/log/account.log
 
```   
