# Docker Compose方式安装 {#install_docker_compose}

## 环境要求
- Docker
- Docker Compose

依赖于 docker-compose.yml 文件，该文件包含了服务的配置信息，如端口、环境变量、挂载卷等。

相关安装命令
```shell
# 赋予执行权限
chmod +x ./dectask
# 构建镜像
docker build -t dectask-server .
# 启动服务
docker-compose up -d
# 查看容器
docker-compose ps -a
# 如果没有启动成功，手动安装初始化数据库
docker-compose exec dectask sh
rm -f ./install.lock
./dectask install zh_cn -y
exit
# 查看管理员账号和密码
docker-compose exec dectask cat /app/log/account.log
# 重新启动
docker-compose stop dectask
docker-compose start dectask

# 如果已经启动，重新部署，则先执行以下命令
docker-compose down -v

# 查看容器
docker-compose ps -a

# 查看日志
docker-compose logs -f dectask

# 进入容器
docker-compose exec dectask sh
docker-compose exec mysql sh
docker-compose exec redis sh
# 进入容器后退出
exit
  
 ``` 