# 项目管理/事项管理

## 事项列表
事项列表是项目管理中最常用的核心视图，它以结构化的表格形式集中展示项目中所有类型的事项，为用户提供全局视角的项目概览。
在左侧导航栏的"项目/事项清单"可以直接查看项目的事项列表。

![事项列表侧边栏](/issue/sidebar_list.png)

或者在项目列表中，直接点击项目名称，即可跳转至项目的事项列表。也可以通过如Url打开事项列表页面：
```
http|https://域名:端口/p/组织标识符/项目标识符/issues
# Url 示例
http://localhost:8080/p/default/proj/issues

```


### 主要功能特点
1. **多维度展示**：
   - 默认显示事项的关键字段，包括：事项名称（标题）、事项类型图标、当前状态标签、优先级标识、负责人头像、创建/截止时间等
   - 支持批量操作，用户可批量选择事项进行批量操作（如分配、关闭、发送邮件、移动等）
   - 支持搜索功能，用户可快速定位特定事项
   - 支持筛选功能，用户可根据状态、类型、优先级等条件筛选事项
   - 支持排序功能，用户可根据不同字段（如事项名称、创建时间、截止时间等）排序


2. **人性化交互设计**：
   - 就近操作设计，当用户拥有系统管理或项目管理权限时，可在相关界面进行管理操作。如自定义表单布局，快速添加项目字典等
   - 直观展示,在左侧可直接列出分类和过滤器，减少二次交互，同时通过选项隐藏左侧分类和过滤器
   - 支持自定义布局，用户可根据需要调整事项列表的显示方式（如列表视图、网格视图等）
   - 支持自定义列，用户可根据需要添加或隐藏特定字段
   - 采用分页加载机制，每页默认显示20条事项，支持调整每页显示数量
   - 鼠标悬停时可预览事项的概要信息，无需进入详情页即可了解关键内容
   - 通过表头点击可快速切换排序方式（升序/降序）

3. **视觉设计**：
   - 不同类型的事项会显示对应的图标标识（如任务、Bug、需求等）
    - 支持自定义图标，用户可根据需要自定义图标
   - 支持自定义颜色编码，用户可根据需要自定义颜色
   - 采用颜色编码系统直观显示事项状态（如红色表示逾期，绿色表示已完成）
   - 支持鼠标悬停时交替行配色，提高长列表的可读性
   

![事项列表截图](/issue/list.png)

## 事项详情
事项详情页面提供了单个事项的完整信息展示和操作入口，是进行事项深度管理的核心界面。 
事项界面如下：  
![事项详情截图](/issue/detail.png)

事项详情打开方式：
1. 直接点击事项列表中的事项标题
2. 鼠标移动到事项标题上方，点击右侧显示`...`图标按钮，再点击"打开详情页"或“新标签页打开”按钮
如下图：
![事项详情打开方式](/issue/list_row_hover_detail.png)

3. 支持事项详情的打开方式设置：当点击事项标题时，可以触发一下三种打开方式
   - 侧边栏打开（默认）
   - 新标签页打开
   - 当前标签页打开
点击当前事项列表页面的右上方`设置`按钮，即可打开事项详情的打开方式设置，如下图： 

![事项详情打开方式设置](/issue/detail_open_option.png)

4. 也直接访问以下Url
```
http|https://域名:端口/p/组织标识符/项目标识符/issue/detail/事项id
# Url 示例
http://localhost:8080/p/default/proj/issues/detail/1

```

### 页面结构详解
1. **头部信息区**：
   - 醒目的标题展示区域，除标题还包含事项编号、类型、创建时间信息 
   - 快捷动作按钮，如跳转评论、动态、上一个事项、下一个事项、关注、编辑、复制、删除等

2. **基本信息区**：
  - 事项的重要属性展示，如事项名称、事项类型、状态、优先级、负责人、截止时间等
  - 支持直接编辑事项的属性，当鼠标移动上方悬停时，可直接进行修改
  - 后续优化该功能：自定义布局事项的属性和编辑方式，如拖拽、调整顺序等

2. **内容主体区**（采用标签页设计）：
   - **详情**：富文本编辑器支持的事项描述，可插入图片、表格等
   - **附件**：支持上传和管理各类文件，显示文件类型图标和大小
   - **子事项**：可分解为多个子任务的树形结构展示
   - **评论**：团队协作讨论区，支持@提及和表情回复
   - **动态**：完整记录事项从创建到当前的所有变更轨迹



## 事项操作

### 创建事项
创建新事项是项目管理中最基础也是最重要的操作之一。

**标准创建流程**：
1. 通过以下任一方式启动创建：
   - 点击事项列表页面右上方的"新增"按钮
   - 使用快捷键 `alt+c` 或 `shift+e`


![新增事项按钮](/issue/button_add.png)


2. 点击事项列表页面右上方的"新增"下拉箭头按钮时可以选择事项类型：
   - 任务（常规工作项）
   - 问题/Bug（需修复的问题）
   - 需求（新功能需求）
   - 改进（体验优化项）
   - 其他项目可以的类型 

   如果直接点击新增按钮，默认创建用户设置的事项类型。


  ![新增事项下拉箭头](/issue/dropdown_add.png)

3. 填写核心字段：
   - 标题（简明扼要的描述）
   - 经办人（也叫负责人，可从团队成员中选择）
   - 优先级 
   - 截止时间（支持精确到小时）

![新增事项截图](/issue/create.png)

4. 保存选项：
   - "保存"：完成创建返回列表, 可使用快捷键 `ctrl+shift+enter`  执行保存操作
   - "保存并新建"：连续创建模式


### 编辑事项
保持事项信息的及时更新是项目管理的关键。

**编辑事项方式**：
- 鼠标移动到要编辑的事项标题上方，直接点击右侧显示的编辑图标按钮
![编辑事项](/issue/row-edit.png)
- 鼠标移动要编辑的到事项标题上方，点击右侧显示`...`图标按钮，再点击"编辑"按钮
![编辑事项](/issue/dropdown_edit.png)
- 鼠标移动要编辑的到事项标题上方，使用快捷键 `shift+e`
- 在事项详情页点击右上角"编辑"按钮
- 可使用快捷键 `ctrl+shift+enter`  执行保存操作

![编辑事项](/issue/edit.png)

**编辑功能特点**：
- 支持全字段修改
- 关键字段变更会触发通知
- 重要修改建议填写变更说明
- 系统自动记录编辑历史

### 删除事项
删除事项是项目管理中常见的操作，用于移除不再需要的事项。
删除事项后，系统会提示确认删除，确认后即可删除。


**删除注意事项**：
1. 删除前系统会检查：
   - 是否存在关联的子事项
   - 是否有未完成的依赖事项

2. 确认删除后：
   - 其任务自动变成普通事项
   - 其甘特图依赖的事项被置空
   - 归档删除（可后期恢复）

### 复制事项
**复制功能应用场景**：
- 创建相似事项时复用内容
- 拆分复杂事项为多个副本
- 创建周期性重复事项


## 批量操作
批量处理功能可显著提升管理效率，特别是在处理大量相似事项时。
在事项列表页面可以批量修改事项如下属性（字段）：
- 事项类型
- 状态
- 解决结果
- 优先级
- 经办人（负责人）
- 模块
- 迭代
- 影响版本
- 解决版本
- 动态
也可以是对多个事项进行如下操作：
- 关注事项
- 取消关注事项
- 指定父任务
- 删除
- 发送邮件
- 移动到其他项目
![批量操作截图](/issue/batch_action.png)

## 筛选&排序&过滤器
强大的筛选系统帮助用户快速定位目标事项。

### 多种筛选方式
1. **便捷筛选栏**（常驻显示）  
   在事项列表页面的上方和左侧，分别有分类筛选、已有过滤器的快捷筛选
如下图：
![便捷筛选栏](/issue/filter_bar.png)


2. **快速筛选操作**  
    点击事项列表右上方的的`查询`按钮，即可打开快速筛选操作面板，如下图：
    ![快速筛选操作](/issue/filter_quick.png)


3. **高级筛选面板**  
   支持多个事项字段的多条件且可嵌套的筛选条件，能满足各种需求的复杂查询情况
   点击事项列表右上方的的`查询`按钮，再点击`高级查询`按钮即可。
   高级查询支持多个字段，且会自动根据字段类型进行条件供筛选，根据与字段不同的类型，也会提供不同的筛选操作符条件。
   支持 嵌套 和 逻辑运算符（与、或）。
   支持 自定义字段 条件筛选。
   支持多字段排序

   如下图：
   ![高级筛选面板](/issue/filter_advanced.png)

   当进行确定查询时，会出现查询结果和条件展示，也可以进行条件重置和保存为用户自己的过滤器，如下图：
   ![高级筛选结果](/issue/filter_bars.png)
   
 **保存过滤器**
   - 可将筛选的条件组合保存为过滤器，这样下次可以直接使用这个过滤器进行筛选
   - 支持团队共享过滤器 

### 排序
  支持多字段组合排序，如先按优先级排序，再按截止时间排序。
  点击事项列表右上方的的`排序`按钮即可进行排序操作。

![筛选排序截图](/issue/filter_sort.png)


点击想要排序的字段，之后将会在筛选栏中出现，如下图。点击排序字段可修改排序方向。点击"+排序"可增加排序字段。

![筛选排序](/issue/filter_sort_bar.png)



## 界面设置

 可以根据你的喜好，隐藏或显示事项列表页面的头部事项介绍和左侧的分类和过滤器列表，以及表格数据的显示方式。默认显示头部事项介绍和左侧的分类和过滤器列表。如果你想使界面更简洁，可以通过以下操作进行隐藏h或显示：

 界面设置操作如下：
 1. 点击事项列表右上方的`设置`按钮，打开界面设置。
 2. 点击`显示相关`， 操作你想要的设置项。

 ![显示相关](/issue/display_setting.png)
 
 显示或隐藏：头部事项介绍和左侧的分类和过滤器列表 

 ![隐藏UI](/issue/hide_header_sidebar.png)

 ![隐藏UI](/issue/hide_header_sidebar2.png)

### 字段显示设置 
你可以设置哪些字段在事项列表中显示，哪些字段不显示。并进行排序。
系统冻结ID列在列表的最左侧，事项标题页默认冻结。

通过以下操作之一进行字段显示设置：
- 在设置界面中进行操作：  
   1. 点击事项列表右上方的`设置`按钮，打开设置。
   2. 点击`显示相关/字段显示` 

   ![字段显示设置](/issue/display_fields.png)

   3. 在已隐藏的字段列表中，选择要显示的字段，点击"启用"。 可以在已显示的字段列表中，选择要隐藏的字段，点击"禁用"。可以拖拽已显示的字段，改变显示顺序。
  ![字段显示设置](/issue/display_fields2.png)

 - 列表表头操作：  
   可对拖动列表表头之间的竖线可进行调整改列字段的宽度
   拖拽列表表头的字段名称，即可对该字段进行排序。
   点击列表表头的字段名称，再点击`添加未使用的字段`按钮，即可添加未使用的字段。
   点击列表表头的字段名称，再点击`隐藏当前字段`按钮，即可对该字段进行隐藏。


### 数据单元格操作
在任何事项列表单元格的数据进行点击键点击可唤出智能菜单，对当前数据进行编辑。如下图：
![数据单元格操作](/issue/cell_operation1.png)
![数据单元格操作](/issue/cell_operation2.png)
![数据单元格操作](/issue/cell_operation3.png)



## 表单自定义布局
 
 不同的事项类型，系统会默认显示不同的表单布局。
 你可以根据自己的需求，自定义表单布局。前提是具备系统管理权限和项目管理权限。

 自定义表单布局操作如下两种方法之一：
 1. 在项目设置中点击`表单布局`，打开设置。针对不同类型，在创建或编辑模式的下的字段布局设置。
   ![项目设置](/common/sidebar_project_setting.png)  
    
   ![表单设置](/setting/form_layout.png)

 2. 在事项创建或编辑表单中，启用右侧`自定义布局`选项，即可选择自定义布局。
   ![自定义布局](/issue/form_layout.png)

 
 可以添加、移除字段，并进行排序。后续版本将增加对每个字段设置属性，如何必填项，默认值等。



## 键盘快捷键
| 快捷键 | 功能描述 |
|--------|----------|
| `shift+p`    | 创建项目 （项目列表页面可用）|
| `ctrl+shift+enter`    | 保存当前的事项 |
| `alt+c`或`shift+c`    | 快速创建新事项（事项列表页面可用） |
| `shift+e`    | 快速编辑事项（事项列表页面中，鼠标移动到事项上方，可用） |
| `shift+d`    | 快速删除事项（事项列表页面中，鼠标移动到事项上方，可用） |
 

 ## 更多操作

 点击事项列表右上方的的`...`按钮, 可进行更多操作：打开个人过滤器、项目共享的过滤器、项目设置的事项选项、导入导出事项、全局设置功能。
  ![更多操作](/issue/more_opt.png)


