# 项目报告 {#report}

## 概述
项目报告模块提供强大的报告生成功能，帮助项目团队创建专业、直观的项目进展报告。 
一个项目有多个报告，每个报告包含多个：静态或动态组件，组件可以是文本 图片 表格或图表等 
系统预制基本的静态组件如：文本、图片、表格、视频、动画等，这些组件可以设置样式如：颜色 字体等 
系统预制基本的动态组件如：事项数据汇总、按负责人图表、按类型图表、按优先级图表、按状态 
可以自定义图表：基于Ai辅助生成；手动：生成图表； 
可以创建数据源，数据源为图表提供数据 

点击左侧菜单某个项目的"看板管理"，即可查看该项目的看板管理。或者以下Url访问：
`/p/{org_path}/{project_key}/report`  

`{org_path}`：组织标识符，用于唯一标识一个组织。`{project_key}`：项目标识符，用于唯一标识一个项目。  
 示例 
`http://localhost:8888/p/default/p1/report`

 ![报告管理界面](/report/index.png)



## 报告管理

### 创建报告
1. 在页面右上方点击「新建报告」
2. 填写报告基本信息：
   - 报告名称
   - 报告图片
   - 布局方式（目前仅支持自由布局）
3. 点击「确定」创建报告，然后进入报告制作页面
4. 在报告制作页面，拖拽左侧「组件」，拖拽到报告中
5. 配置组件属性，如数据来源、图表类型、标题、标签等
6. 每次操作自动保存，无需点击保存按钮

![报告管理界面](/report/add.png)

![报告管理界面](/report/edit.png)
 左侧为报告组件库，中间为报告内容显示区域，右侧为组件属性设置区域

 组件如何布局
- **拖拽加入**：拖拽组件加入到报告中
- **拖拽排序**：自由调整组件位置
 
 


### 编辑报告
- 可编辑报告名称、图片基本信息
- 报告内容编辑与创建报告后的操作一致


### 导出报告
 支持PDF、图片格式 
![报告管理界面](/report/export.png)


## 报告组件系统

报告由多个组件构成，分为静态组件和动态组件两大类。

### 静态组件
  静态组件为固定内容，不支持数据绑定。
  静态组件包括：文本、图片、表格、视频、动画等。
  可以的静态组件： 

  ![静态组件](/report/static_com.png)

  图片组件属性示例：

  ![静态组件](/report/static_com_attr.png)



### 动态组件
  动态组件为动态内容，支持数据绑定。
  系统内置了动态组件包括：事项数据汇总、按负责人图表、按类型图表、按优先级图表、按状态图表等。
  用户可以创建自定义动态组件，目前仅支持图表类型，如：按项目图表、按时间图表等。 
  当用户创建好图表后，自动出现在编辑报告的左侧动态组件中，添加方式与添加其他组件相同。

  ![动态组件](/report/dynamic_com.png)


## 图表管理
  图表管理主要用于创建自定义图表，支持图表库：Antd Design Cahrt、Echart、ChartJs。
  提供三种创建方式: Ai辅助创建、可视化创建、基于配置文件创建。
  图表类型包括：折线图、柱状图、饼图等基础图表，也包括：散点图、气泡图等高级图表，还包括：组合图表（多种类型组合）。
   图表依赖数据，用户可以选择多种来源：样例数据、数据源、上传文件、Api，确定后根据图表类型绑定特点数据字段即可。
  图表管理界面：
  ![图表管理界面](/report/chart_list.png)

  创建图表界面：
  ![创建图表界面](/report/chart_add.png)


  图表属性：
  ![图表属性](/report/chart_content.png)

   图表数据来源：
  ![图表数据来源](/report/chart_data.png)

  图表数据字段绑定：
  ![图表数据字段](/report/chart_bind_fields.png)

 

## 数据源管理

  可以创建多个数据源，每个数据源方式有：Sql、手动上传、可视化连表获取。
  目前版本仅支持Sql数据源。Sql语句支持参数绑定。

  数据源管理界面：
  ![数据源管理界面](/report/datasource_list.png)

  数据源添加界面：
  ![数据源添加界面](/report/datasource_add.png)

  数据源编辑界面：
  ![数据源编辑界面](/report/datasource_edit.png)


 
