const r="const data = [\r\n  { quarter: '第一季度', value: 6200000 },\r\n  { quarter: '第二季度', value: -2600000 },\r\n  { quarter: '第三季度', value: 4100000 },\r\n  { quarter: '第四季度', value: 3700000 },\r\n  { quarter: '总计', value: 11400000, isTotal: true },\r\n];\r\nconst config = {\r\n  data,\r\n  xField: 'quarter',\r\n  yField: 'value',\r\n  linkStyle: {\r\n    lineDash: [4, 2],\r\n    stroke: '#ccc',\r\n  },\r\n  style: {\r\n    maxWidth: 60,\r\n    stroke: '#ccc',\r\n    fill: (d) => {\r\n      return d.isTotal ? '#96a6a6' : d.value > 0 ? '#F56E53' : '#3CC27F';\r\n    },\r\n  },\r\n  label: [\r\n    {\r\n      text: 'value',\r\n      formatter: '~s',\r\n      position: 'inside',\r\n      fontSize: 10,\r\n    },\r\n    {\r\n      text: (arg) => {\r\n        return `${arg.y1 / 10000000} 亿`;\r\n      },\r\n      position: (d) => (d.value > 0 ? 'top' : 'bottom'),\r\n      textBaseline: (d) => (d.value > 0 ? 'bottom' : 'top'),\r\n      fontSize: 10,\r\n      dy: (d) => (d.value > 0 ? -4 : 4),\r\n    },\r\n  ],\r\n};\r\n";export{r as default};
